/*
 * Decompiled with CFR 0.152.
 */
package pse.util.general;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParsingErrorHandler
implements ErrorHandler {
    protected String sourceName;
    protected boolean havePrintedSource = false;

    public XmlParsingErrorHandler(String string) {
        this.sourceName = string;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (!this.havePrintedSource) {
            System.out.println("Warnings/Errors while parsing " + this.sourceName + ":");
            this.havePrintedSource = true;
        }
        System.out.println("\tError: Sys=" + sAXParseException.getSystemId() + " Pub=" + sAXParseException.getPublicId() + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (!this.havePrintedSource) {
            System.out.println("Warnings/Errors while parsing " + this.sourceName + ":");
            this.havePrintedSource = true;
        }
        System.out.println("\tFatal Error: Sys=" + sAXParseException.getSystemId() + " Pub=" + sAXParseException.getPublicId() + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (!this.havePrintedSource) {
            System.out.println("Warnings/Errors while parsing " + this.sourceName + ":");
            this.havePrintedSource = true;
        }
        System.out.println("\tWarning: Sys=" + sAXParseException.getSystemId() + " Pub=" + sAXParseException.getPublicId() + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }
}

